#!/usr/bin/env python
"""
Kolorowa wersja gry Snap
"""
import time                 # Na potrzeby dodawania opóźnień
import piface.pfio as pfio  # Biblioteka piface
import os, pygame, sys
import random
import pygame
from pygame.locals import *
import shelve
pygame.init()
pygame.mixer.quit()
pygame.mixer.init()
pfio.init()         # Inicjowanie biblioteki piface

snapSound1 = pygame.mixer.Sound("sounds/snap1.ogg")
snapSound2 = pygame.mixer.Sound("sounds/snap2.ogg")
tickSound = pygame.mixer.Sound("sounds/tick.ogg")
applauseSound = pygame.mixer.Sound("sounds/applause.ogg")
dohSound = pygame.mixer.Sound("sounds/doh.ogg")

easyCols = [ 0x3, 0xC, 0xF, 0x30, 0x33, 0x3C, 0x3F ]
intCols = [ 0x3, 0xC, 0xF, 0x30, 0x33, 0x3C, 0x3F,
              0x1, 0x4, 0x5, 0x10, 0x11, 0x14, 0x15]
colours = [ easyCols, intCols ]
level = 2 # 0 = najłatwiejszy poziom 2 = najtrudniejszy poziom
playerName = ["Brak gracza", "Gracz niebieski","Gracz czerwony"]
countToMatch = 0
roundToPlay = 1 # Numer rundy
maxRound = 3 # Liczba rund do rozegrania
redScore = 0
blueScore = 0

def main():
        global level
        print"Kolorowa wersja gry Snap. Wciśnij Ctrl+C, aby zakończyć."
        show_table()
        playerName[1] = raw_input("Wpisz imię gracza używającego niebieskiego przycisku ")
        p1Score = set_table(playerName[1], 0); # Upewnianie się, że gracz znajduje się w bazie
        print "Dotychczasowy wynik gracza",playerName[1],"to",p1Score
        playerName[2] = raw_input("Wpisz imię gracza używającego czerwonego przycisku ")
        p2Score = set_table(playerName[2], 0); #Upewnianie się, że gracz znajduje się w bazie
        print "Dotychczasowy wynik gracza",playerName[2],"to",p2Score        
        il = raw_input ("Podaj poziom trudności - od 1 (niski) do 3 (wysoki) ")
        level = int(il)-1
        # Sprawdzanie, czy podany poziom znajduje się w dozwolonym przedziale
        if level>2:
                level=2
        if level < 0:
                level = 0
        lc = random.randint(0,63) # Ostatni wyświetlany kolor
        while roundToPlay <= maxRound :
            print "Runda ",roundToPlay, " z ",maxRound    
            countToMatch = random.randint(3, 10)
            while countToMatch !=0 : # Powtarzanie do czasu dojścia do docelowej wartości
                 countToMatch -= 1
                 if countToMatch != 0 : # W ostatniej kolejce nie należy generować nowego koloru
                      c = newColour(lc);  
                 tickSound.play()
                 time.sleep(0.5)
                 pfio.write_output(c)  # Włączanie koloru  
                 checkInput(0.8, c, lc)
                 pfio.write_output(0) # Wyłączanie diody
                 checkInput(0.9, c, lc)
                 lc = c # Zapisywanie poprzedniego koloru
        print "Koniec gry"
        if blueScore == redScore :
                print"REMIS!!! "
        else:
                win = 2
                if blueScore > redScore :
                    win = 1
                print"Wygrał ",playerName[win]
        p1Score += blueScore
        set_table(playerName[1], p1Score);
        p2Score += redScore
        set_table(playerName[2], p2Score);
        print"Aktualizowanie tabeli rekordów"
        show_table()
        # Koniec głównej funkcji
       
def newColour(lastColour) :
        nc = lastColour
        if level == 2 : # Najwyższy poziom
                nc ^= 1 << random.randint(0,5) # Zmiana o tylko jeden bit
        else:
             while nc == lastColour : # Powtarzanie do czasu wygenerowania nowego koloru
                 nc = colours[level][random.randint(0,len(colours[level])-1)]
        return nc

def checkInput(delay, c, lc) : # Obsługa wciśnięcia przycisku
        nextTime = time.time() + delay
        buttonPress = 0
        while nextTime > time.time() and buttonPress == 0 :
             buttonPress = pfio.read_input() & 3
        if buttonPress != 0 :
                if buttonPress & 1 :
                     snapSound1.play()
                else :
                     snapSound2.play()  
                checkResult(buttonPress, c, lc)
                while buttonPress !=0 : # Wstrzymywanie operacji do momentu zwolnienia przycisku
                        buttonPress = pfio.read_input() & 3

def checkResult(player, newColour, lastColour) :
        global countToMatch, roundToPlay, blueScore, redScore, level
        pfio.write_output(0) # Wyłączanie diody
        time.sleep(0.8)
        count = 0 
        print playerName[player],
        if lastColour == newColour :
                print"yes"
                applauseSound.play()
                roundToPlay += 1
                # Dodawanie punktów dla gracza, który trafnie wykrył zgodność kolorów
                if player == 1 :
                        blueScore += level +1
                else:
                        redScore += level +1
        else :
                print "Niestety, pomyłka"
                dohSound.play()
                # Kara za wciśnięcie przycisku w nieodpowiednim momencie
                if player == 1 :
                        blueScore -= 1 * (level +1)
                else:
                        redScore -= 1 * (level +1)

                
        while player !=0 or count < 6: # Powtarzane do czasu zwolnienia przycisku lub sześciu mignięć
                pfio.write_output(lastColour)
                time.sleep(0.3)
                pfio.write_output(newColour)
                time.sleep(0.3)
                player = pfio.read_input() & 3
                count +=1
        pfio.write_output(0) # Wyłączenie diody
        time.sleep(2)
        countToMatch = random.randint(3, 10)

def set_table(name, score):
        scoretable = shelve.open('score_table.snap')
        if not name in scoretable:
                scoretable[name] = score
        elif score > scoretable[name]:
                scoretable[name] = score
        else :
              score = scoretable[name]
        scoretable.close()
        return score

def show_table():
        print
        print "Lista rekordów:"
        scoretable = shelve.open('score_table.snap')
        highscores = scoretable.items()
        highscores.sort(key=lambda elem: elem[1], reverse=True)
        for entry in highscores:
                print entry[0], "liczba punktów:",entry[1]
        scoretable.close()
        print
        
if __name__ == '__main__':
    main()   
